<?php

/**
 * @package Jollyany Addons SP Page Builder
 * @author TemPlaza https://templaza.com
 * @copyright Copyright (c) 2011 - 2021 TemPlaza
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('Restricted access');

SpAddonsConfig::addonConfig(
	array(
		'type' => 'repeatable',
		'addon_name' => 'uigallery',
		'title' => JText::_('UI Filter Gallery'),
		'desc' => JText::_('Create beautiful gallery with Masonry effect for the Grid and the Gallery element. The Masonry effect, as most of you know, allows you to have a gap-free multi-column layout even when grid cells have a different height. '),
		'icon'=>JURI::root() . 'plugins/sppagebuilder/jollyany/addons/uigallery/assets/images/icon.png',
		'category' => 'Jollyany',
		'attr' => array(
			'general' => array(
				'admin_label' => array(
					'type' => 'text',
					'title' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std' => ''
				),
				'title_addon' => array(
					'type' => 'text',
					'title' => JText::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
					'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
					'std' =>  '',
				),
				'title_heading_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
					'values' => array(
						'' => JText::_('None'),
						'heading-2xlarge' => JText::_('2XLarge'),
						'heading-xlarge' => JText::_('XLarge'),
						'heading-large' => JText::_('Large'),
						'heading-medium' => JText::_('Medium'),
						'heading-small' => JText::_('Small'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => 'h3',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_margin' => array(
					'type' => 'select',
					'title' => JText::_('Title Margin'),
					'desc' => JText::_('Set the vertical margin for title.'),
					'values' => array(
						'' => JText::_('Keep existing'),
						'uk-margin-small' => JText::_('Small'),
						'uk-margin' => JText::_('Default'),
						'uk-margin-medium' => JText::_('Medium'),
						'uk-margin-large' => JText::_('Large'),
						'uk-margin-xlarge' => JText::_('X-Large'),
						'uk-margin-remove-vertical' => JText::_('None'),
					),
					'std' => 'uk-margin',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_decoration' => array(
					'type' => 'select',
					'title' => JText::_('Decoration'),
					'desc' => JText::_('Decorate the heading with a divider, bullet or a line that is vertically centered to the heading'),
					'values' => array(
						'' => JText::_('None'),
						'uk-heading-divider' => JText::_('Divider'),
						'uk-heading-bullet' => JText::_('Bullet'),
						'uk-heading-line' => JText::_('Line'),
					),
					'std' => '',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_color' => array(
					'type' => 'select',
					'title' => JText::_('Color'),
					'desc' => JText::_('Select the text color. If the Background option is selected, styles that don\'t apply a background image use the primary color instead.'),
					'values' => array(
						'' => JText::_('None'),
						'text-muted' => JText::_('Muted'),
						'text-emphasis' => JText::_('Emphasis'),
						'text-primary' => JText::_('Primary'),
						'text-secondary' => JText::_('Secondary'),
						'text-success' => JText::_('Success'),
						'text-warning' => JText::_('Warning'),
						'text-danger' => JText::_('Danger'),
						'text-background' => JText::_('Background'),
					),
					'std' => '',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_selector' => array(
					'type' => 'select',
					'title' => JText::_('HTML Element'),
					'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
					'values' => array(
						'h1' => JText::_('h1'),
						'h2' => JText::_('h2'),
						'h3' => JText::_('h3'),
						'h4' => JText::_('h4'),
						'h5' => JText::_('h5'),
						'h6' => JText::_('h6'),
						'div' => JText::_('div'),
					),
					'std' => 'h3',
					'depends' => array(array('title_addon', '!=', '')),
				),
				// Repeatable Items
				'ui_filter_gallery_item' => array(
					'title' => JText::_('Items'),
					'attr' => array(
						'title' => array(
							'type' => 'text',
							'title' => JText::_('Title'),
							'std' => 'Item',
						),
						'media_item' => array(
							'type' => 'media',
							'title' => JText::_('Image'),
							'placeholder' => 'http://www.example.com/my-photo.jpg',
						),
						'media_item_thumb' => array(
							'type' => 'media',
							'title' => JText::_('Thumbnail'),
							'placeholder' => 'http://www.example.com/my-photo.jpg',
						),
						'image_alt' => array(
							'type' => 'text',
							'title' => JText::_('Image Alt'),
							'std' => 'Image Alt',
						),
						'meta' => array(
							'type' => 'text',
							'title' => JText::_('Meta'),
						),
						'content' => array(
							'type' => 'editor',
							'title' => JText::_('Content'),
						),
						'tag_name' => array(
							'type' => 'text',
							'title' => JText::_('Tag Name'),
							'desc' => JText::_('Enter a comma-separated list of tags, for example: blue, white, black.'),
							'std' => 'Home',
						),
						'title_link' => array(
							'type' => 'media',
							'format' => 'attachment',
							'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
							'placeholder' => 'http://www.example.com',
							'std' => '',
							'hide_preview' => true,
						),
						'media_item_hover' => array(
							'type' => 'media',
							'title' => JText::_('Hover Image'),
							'desc' => JText::_('Select an optional image that appears on hover.'),
							'placeholder' => 'http://www.example.com/my-photo.jpg',
						),
						'item_color' => array(
							'type' => 'select',
							'title' => JText::_('Text Color'),
							'desc' => JText::_('Set a different text color for this item.'),
							'values' => array(
								'' => JText::_('None'),
								'light' => JText::_('Light'),
								'dark' => JText::_('Dark'),
							),
							'std' => '',
						),
					),
				),

				'separator_gallery_options' => array(
					'type' => 'separator',
					'title' => JText::_('Gallery'),
				),
				'masonry' => array(
					'type' => 'checkbox',
					'title' => JText::_('Enable masonry effect'),
					'desc' => JText::_('The masonry effect creates a layout free of gap even if grid cell have different height.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'grid_parallax' => array(
					'type' => 'slider',
					'title' => JText::_('Parallax'),
					'desc' => JText::_('To move single columns of a grid at different speeds while scrolling'),
					'min' => 0,
					'max' => 600,
				),
				'grid_column_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Column Gap'),
					'desc' => JText::_('Set the size of the gap between the grid columns.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
				),
				'grid_row_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Row Gap'),
					'desc' => JText::_('Set the size of the gap between the grid rows.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
				),
				'divider' => array(
					'type' => 'checkbox',
					'title' => JText::_('Show dividers'),
					'desc' => JText::_('Select this option to separate grid cells with lines.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
					'depends' => array(
						array('grid_column_gap', '!=', 'collapse'),
						array('grid_row_gap', '!=', 'collapse'),
					),
				),
				'grid_column_align' => array(
					'type' => 'checkbox',
					'title' => JText::_('Center columns'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'grid_row_align' => array(
					'type' => 'checkbox',
					'title' => JText::_('Center rows'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'separator_grid_column_options' => array(
					'type' => 'separator',
					'title' => JText::_('Columns'),
				),
				'phone_portrait' => array(
					'type' => 'select',
					'title' => JText::_('Phone Portrait'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => '1',
				),
				'phone_landscape' => array(
					'type' => 'select',
					'title' => JText::_('Phone Landscape'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => '',
				),
				'tablet_landscape' => array(
					'type' => 'select',
					'title' => JText::_('Tablet Landscape'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => '3',
				),
				'desktop' => array(
					'type' => 'select',
					'title' => JText::_('Desktop'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => '',
				),
				'large_screens' => array(
					'type' => 'select',
					'title' => JText::_('Large Screens'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => '',
				),
				'separator_filter_options' => array(
					'type' => 'separator',
					'title' => JText::_('Filter'),
				),
				'enable_filter' => array(
					'type' => 'checkbox',
					'title' => JText::_('Enable filter navigation'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 1,
				),
				'filter_reverse' => array(
					'type' => 'checkbox',
					'title' => JText::_('Reverse order'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
					'depends' => array('enable_filter' => 1),
				),
				'filter_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select the filter style. The pill and divider styles are only available for horizontal subnavs'),
					'values' => array(
						'tab' => JText::_('Tabs'),
						'subnav-pill' => JText::_('Subnav Pill (Nav)'),
						'subnav-divider' => JText::_('Subnav Divider (Nav)'),
						'subnav' => JText::_('Subnav (Nav)'),
					),
					'std' => 'tab',
					'depends' => array('enable_filter' => 1),
				),
				'all_control' => array(
					'type' => 'text',
					'std' => 'All',
					'title' => JText::_('Replace All tag'),
					'desc' => JText::_('Add your text to replace the \'All\' tag title'),
					'depends' => array('enable_filter' => 1),
				),
				'positions' => array(
					'type' => 'select',
					'title' => JText::_('Position'),
					'desc' => JText::_('Position the navigation at the top, bottom, left or right. A larger style can be applied to left and right navigations.'),
					'values' => array(
						'top' => JText::_('Top'),
						'left' => JText::_('Left'),
						'right' => JText::_('Right'),
					),
					'std' => 'top',
					'depends' => array('enable_filter' => 1),
				),
				'filter_style_primary' => array(
					'type' => 'checkbox',
					'title' => JText::_('Primary navigation'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
					'depends' => array(
						array('enable_filter', '=', 1),
						array('positions', '!=', 'top'),
						array('filter_style', '=', 'subnav'),
					),
				),
				'filter_alignment' => array(
					'type' => 'select',
					'title' => JText::_('Alignment'),
					'desc' => JText::_('Align the navigation\'s items.'),
					'values' => array(
						'left' => JText::_('Left'),
						'center' => JText::_('Center'),
						'right' => JText::_('Right'),
						'justify' => JText::_('Justify'),
					),
					'std' => 'left',
					'depends' => array(
						array('positions', '!=', 'left'),
						array('positions', '!=', 'right'),
						array('enable_filter', '=', 1),
					),
				),
				'filter_margin' => array(
					'type' => 'select',
					'title' => JText::_('Margin'),
					'desc' => JText::_('Set the vertical margin.'),
					'values' => array(
						'small' => JText::_('Small'),
						'' => JText::_('Default'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
					),
					'std' => '',
					'depends' => array(
						array('positions', '=', 'top'),
						array('enable_filter', '=', 1),
					),
				),
				'grid_width' => array(
					'type' => 'select',
					'title' => JText::_('Grid Width'),
					'desc' => JText::_('Define the width of the navigation. Choose between percent and fixed widths or expand columns to the width of their content'),
					'values' => array(
						'auto' => JText::_('Auto'),
						'1-2' => JText::_('50%'),
						'1-3' => JText::_('33%'),
						'1-4' => JText::_('25%'),
						'1-5' => JText::_('20%'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
					),
					'std' => 'auto',
					'depends' => array(
						array('positions', '!=', 'top'),
						array('enable_filter', '=', 1),
					),
				),
				'filter_grid_column_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Column Gap'),
					'desc' => JText::_('Set the size of the gap between between the filter navigation and the content.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
					'depends' => array(
						array('positions', '!=', 'top'),
						array('enable_filter', '=', 1),
					),
				),
				'filter_grid_row_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Row Gap'),
					'desc' => JText::_('Set the size of the gap if the grid items stack.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
					'depends' => array(
						array('positions', '!=', 'top'),
						array('enable_filter', '=', 1),
					),
				),
				'grid_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Grid Breakpoint'),
					'desc' => JText::_('Set the breakpoint from which the navigation and content will stack.'),
					'values' => array(
						's' => JText::_('Small (Phone Landscape)'),
						'm' => JText::_('Medium (Tablet Landscape)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => 'm',
					'depends' => array(
						array('positions', '!=', 'top'),
						array('enable_filter', '=', 1),
					),
				),
				'switcher_font_family'=>array(
					'type'=>'fonts',
					'title'=>JText::_('Font Family'),
					'selector'=> array(
						'type'=>'font',
						'font'=>'{{ VALUE }}',
						'css'=>'.tz-filter>*>a { font-family: {{ VALUE }}; }',
					)
				),
				'separator_lightbox_options' => array(
					'type' => 'separator',
					'title' => JText::_('Lightbox'),
				),
				'lightbox' => array(
					'type' => 'checkbox',
					'title' => JText::_('Enable lightbox gallery'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'show_lightbox_title' => array(
					'type' => 'select',
					'title' => JText::_('Show Title'),
					'desc' => JText::_('Display the title inside the overlay, as the lightbox caption or both.'),
					'values' => array(
						'' => JText::_('Overlay + Lightbox'),
						'title-ovl' => JText::_('Overlay only'),
						'title-lightbox' => JText::_('Lightbox only'),
					),
					'std' => '',
					'depends' => array(
						array('lightbox', '=', 1),
					),
				),
				'show_lightbox_content' => array(
					'type' => 'select',
					'title' => JText::_('Show Content'),
					'desc' => JText::_('Display the content inside the overlay, as the lightbox caption or both.'),
					'values' => array(
						'' => JText::_('Overlay + Lightbox'),
						'content-ovl' => JText::_('Overlay only'),
						'content-lightbox' => JText::_('Lightbox only'),
					),
					'std' => '',
					'depends' => array(
						array('lightbox', '=', 1),
					),
				),
				'separator_item_width_options' => array(
					'type' => 'separator',
					'title' => JText::_('Item'),
				),
				'item_maxwidth' => array(
					'type' => 'select',
					'title' => JText::_('Max Width'),
					'desc' => JText::_('Set the maximum width.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'2xlarge' => JText::_('2X-Large'),
					),
					'std' => '',
				),
				'separator_overlay_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Overlay'),
				),
				'overlay_mode' => array(
					'type' => 'select',
					'title' => JText::_('Mode'),
					'desc' => JText::_('When using cover mode, you need to set the text color manually'),
					'values' => array(
						'cover' => JText::_('Cover'),
						'caption' => JText::_('Caption'),
						'icon' => JText::_('Icon'),
					),
					'std' => 'cover',
				),
				'overlay_on_hover' => array(
					'type' => 'checkbox',
					'title' => JText::_('Display overlay on hover'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 1,
				),
				'icon_text_color' => array(
					'type' => 'select',
					'title' => JText::_('Icon color'),
					'desc' => JText::_('Set light or dark color mode for icon.'),
					'values' => array(
						'' => JText::_('None'),
						'light' => JText::_('Light'),
						'dark' => JText::_('Dark'),
					),
					'std' => 'light',
					'depends' => array(
						array('overlay_mode', '=', 'icon'),
					),
				),
				'overlay_transition_background' => array(
					'type' => 'checkbox',
					'title' => JText::_('Animate background only'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
					'depends' => array(
						array('overlay_on_hover', '=', 1),
						array('overlay_mode', '=', 'cover'),
					),
				),

				'overlay_styles' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select a style for the overlay.'),
					'values' => array(
						'' => JText::_('None'),
						'overlay-default' => JText::_('Overlay Default'),
						'overlay-primary' => JText::_('Overlay Primary'),
						'tile-default' => JText::_('Tile Default'),
						'tile-muted' => JText::_('Tile Muted'),
						'tile-primary' => JText::_('Tile Primary'),
						'tile-secondary' => JText::_('Tile Secondary'),
						'overlay-custom' => JText::_('Custom'),
					),
					'std' => 'overlay-primary',
				),
				'overlay_background' => array(
					'type' => 'color',
					'title' => JText::_('Background Color'),
					'std' => '#ffd49b',
					'depends' => array(
						array('overlay_styles', '=', 'overlay-custom'),
					), 
				),
				'overlay_text_color' => array(
					'type' => 'select',
					'title' => JText::_('Text color'),
					'desc' => JText::_('Set light or dark color mode for text, buttons and controls'),
					'values' => array(
						'' => JText::_('None'),
						'uk-light' => JText::_('Light'),
						'uk-dark' => JText::_('Dark'),
					),
					'std' => 'uk-light',
				),
				'text_color_hover' => array(
					'type' => 'checkbox',
					'title' => JText::_('Inverse the text color on hover'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 1,
					'depends' => array(
						array('overlay_mode', '=', 'cover'),
						array('overlay_on_hover', '=', 1),
						array('overlay_transition_background', '=', 1),
					),
				),
				'overlay_padding' => array(
					'type' => 'select',
					'title' => JText::_('Padding'),
					'desc' => JText::_('Set the padding between the overlay and its content.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'large' => JText::_('Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'overlay_positions' => array(
					'type' => 'select',
					'title' => JText::_('Overlay Positions'),
					'desc' => JText::_('A collection of utility classes to position content.'),
					'values' => array(
						'top' => JText::_('Top'),
						'bottom' => JText::_('Bottom'),
						'left' => JText::_('Left'),
						'right' => JText::_('Right'),
						'top-left' => JText::_('Top Left'),
						'top-center' => JText::_('Top Center'),
						'top-right' => JText::_('Top Right'),
						'bottom-left' => JText::_('Bottom Left'),
						'bottom-center' => JText::_('Bottom Center'),
						'bottom-right' => JText::_('Bottom Right'),
						'center' => JText::_('Center'),
						'center-left' => JText::_('Center Left'),
						'center-right' => JText::_('Center Right'),
					),
					'std' => 'center',
				),
				'overlay_margin' => array(
					'type' => 'select',
					'title' => JText::_('Margin'),
					'desc' => JText::_('Apply a margin between the overlay and the image container.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
					),
					'std' => '',
					'depends' => array(
						array('overlay_styles', '!=', ''),
					)
				),
				'overlay_maxwidth' => array(
					'type' => 'select',
					'title' => JText::_('Max Width'),
					'desc' => JText::_('Set the maximum content width.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
					),
					'std' => '',
				),
				'overlay_transition' => array(
					'type' => 'select',
					'title' => JText::_('Transition'),
					'desc' => JText::_('Select a transition for the overlay when it appears on hover.'),
					'values' => array(
						'fade' => JText::_('Fade'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
						'slide-top-small' => JText::_('Slide Top Small'),
						'slide-bottom-small' => JText::_('Slide Bottom Small'),
						'slide-left-small' => JText::_('Slide Left Small'),
						'slide-right-small' => JText::_('Slide Right Small'),
						'slide-top-medium' => JText::_('Slide Top Medium'),
						'slide-bottom-medium' => JText::_('Slide Bottom Medium'),
						'slide-left-medium' => JText::_('Slide Left Medium'),
						'slide-right-medium' => JText::_('Slide Right Medium'),
						'slide-top' => JText::_('Slide Top 100%'),
						'slide-bottom' => JText::_('Slide Bottom 100%'),
						'slide-left' => JText::_('Slide Left 100%'),
						'slide-right' => JText::_('Slide Right 100%'),
					),
					'std' => 'fade',
					'depends' => array(
						array('overlay_on_hover', '=', 1),
					)
				),
				'icon_transition' => array(
					'type' => 'select',
					'title' => JText::_('Transition'),
					'desc' => JText::_('Select a transition for the icon when it appears on hover.'),
					'values' => array(
						'fade' => JText::_('Fade'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
						'slide-top-small' => JText::_('Slide Top Small'),
						'slide-bottom-small' => JText::_('Slide Bottom Small'),
						'slide-left-small' => JText::_('Slide Left Small'),
						'slide-right-small' => JText::_('Slide Right Small'),
						'slide-top-medium' => JText::_('Slide Top Medium'),
						'slide-bottom-medium' => JText::_('Slide Bottom Medium'),
						'slide-left-medium' => JText::_('Slide Left Medium'),
						'slide-right-medium' => JText::_('Slide Right Medium'),
						'slide-top' => JText::_('Slide Top 100%'),
						'slide-bottom' => JText::_('Slide Bottom 100%'),
						'slide-left' => JText::_('Slide Left 100%'),
						'slide-right' => JText::_('Slide Right 100%'),
					),
					'std' => 'fade',
					'depends' => array(
						array('overlay_on_hover', '=', 1),
						array('overlay_mode', '=', 'icon'),
					)
				),
				'overlay_link' => array(
					'type' => 'checkbox',
					'title' => JText::_('Link Overlay'),
					'desc' => JText::_('Link the whole overlay if a link exists.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'separator_image_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Image'),
				),
				'image_transition' => array(
					'type' => 'select',
					'title' => JText::_('Transition'),
					'desc' => JText::_('Select an image transition. If the hover image is set, the transition takes place between the two images. If <i>None</i> is selected, the hover image fades in.'),
					'values' => array(
						'' => JText::_('None (Fade if hover image)'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
					),
					'std' => '',
				),
				'box_shadow' => array(
					'type' => 'select',
					'title' => JText::_('Box Shadow'),
					'desc' => JText::_('Select the image\'s box shadow size.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
					),
					'std' => '',
				),
				'hover_box_shadow' => array(
					'type' => 'select',
					'title' => JText::_('Hover Box Shadow'),
					'desc' => JText::_('Select the image\'s box shadow size on hover.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
					),
					'std' => '',
				),
				'thumb_width'=>array(
					'type'=>'slider',
					'title'=>JText::_('Thumbnail Width'),
					'placeholder'=>343,
					'std'=>'',
					'max'=> 900,
				),
				'thumb_height'=>array(
					'type'=>'slider',
					'title'=>JText::_('Thumbnail Height'),
					'placeholder'=>214,
					'std'=>'',
					'max'=> 900,
				),
				'separator_title_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Title'),
				),
				'title_transition' => array(
					'type' => 'select',
					'title' => JText::_('Transition'),
					'desc' => JText::_('Select a transition for the title when the overlay appears on hover.'),
					'values' => array(
						'' => JText::_('None'),
						'fade' => JText::_('Fade'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
						'slide-top-small' => JText::_('Slide Top Small'),
						'slide-bottom-small' => JText::_('Slide Bottom Small'),
						'slide-left-small' => JText::_('Slide Left Small'),
						'slide-right-small' => JText::_('Slide Right Small'),
						'slide-top-medium' => JText::_('Slide Top Medium'),
						'slide-bottom-medium' => JText::_('Slide Bottom Medium'),
						'slide-left-medium' => JText::_('Slide Left Medium'),
						'slide-right-medium' => JText::_('Slide Right Medium'),
						'slide-top' => JText::_('Slide Top 100%'),
						'slide-bottom' => JText::_('Slide Bottom 100%'),
						'slide-left' => JText::_('Slide Left 100%'),
						'slide-right' => JText::_('Slide Right 100%'),
					),
					'std' => '',
					'depends' => array(
						array('overlay_on_hover', '=', 1),
						array('overlay_mode', '!=', 'icon'),
					)
				),
				'title_font_family'=>array(
					'type'=>'fonts',
					'title'=>JText::_('Font Family'),
					'selector'=> array(
						'type'=>'font',
						'font'=>'{{ VALUE }}',
						'css'=>'.ui-title { font-family: {{ VALUE }}; }',
					)
				),
				'font_weight' => array(
					'type' => 'select',
					'title' => JText::_('Font weight'),
					'desc' => JText::_('Add one of the following classes to modify the font weight of your text.'),
					'values' => array(
					  '' => JText::_('Default'),
					  'light' => JText::_('Light'),
					  'normal' => JText::_('Normal'),
					  'bold' => JText::_('Bold'),
					  'lighter' => JText::_('Lighter'),
					  'bolder' => JText::_('Bolder'),
					),
				  ),				
				'heading_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
					'values' => array(
						'' => JText::_('None'),
						'heading-2xlarge' => JText::_('2XLarge'),
						'heading-xlarge' => JText::_('XLarge'),
						'heading-large' => JText::_('Large'),
						'heading-medium' => JText::_('Medium'),
						'heading-small' => JText::_('Small'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => '',
				),
				'link_title' => array(
					'type' => 'checkbox',
					'title' => JText::_('Link Title'),
					'desc' => JText::_('Link the title if a link exists.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'title_hover_style' => array(
					'type' => 'select',
					'title' => JText::_('Hover Style'),
					'desc' => JText::_('Set the hover style for a linked title.'),
					'values' => array(
						'reset' => JText::_('None'),
						'heading' => JText::_('Heading Link'),
						'' => JText::_('Default Link'),
					),
					'std' => 'reset',
					'depends' => array(
						array('link_title', '=', 1)
					),
				),
				'title_decoration' => array(
					'type' => 'select',
					'title' => JText::_('Decoration'),
					'desc' => JText::_('Decorate the title with a divider, bullet or a line that is vertically centered to the title'),
					'values' => array(
						'' => JText::_('None'),
						'uk-heading-divider' => JText::_('Divider'),
						'uk-heading-bullet' => JText::_('Bullet'),
						'uk-heading-line' => JText::_('Line'),
					),
					'std' => '',
				),
				'title_color' => array(
					'type' => 'select',
					'title' => JText::_('Predefined Color'),
					'desc' => JText::_('Select the predefined title text color.'),
					'values' => array(
						'' => JText::_('None'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'success' => JText::_('Success'),
						'warning' => JText::_('Warning'),
						'danger' => JText::_('Danger'),
					),
					'std' => '',
				),
				'custom_title_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Custom Color'),
					'depends' => array(
						array('title_color', '=', '')
					),
				),
				'title_text_transform' => array(
					'type' => 'select',
					'title' => JText::_('Transform'),
					'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uppercase' => JText::_('Uppercase'),
						'capitalize' => JText::_('Capitalize'),
						'lowercase' => JText::_('Lowercase'),
					),
					'std' => '',
				),
				'heading_selector' => array(
					'type' => 'select',
					'title' => JText::_('HTML Element'),
					'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
					'values' => array(
						'h1' => JText::_('h1'),
						'h2' => JText::_('h2'),
						'h3' => JText::_('h3'),
						'h4' => JText::_('h4'),
						'h5' => JText::_('h5'),
						'h6' => JText::_('h6'),
						'div' => JText::_('div'),
					),
					'std' => 'h3',
				),
				'title_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'separator_meta_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Meta'),
				),
				'meta_transition' => array(
					'type' => 'select',
					'title' => JText::_('Transition'),
					'desc' => JText::_('Select a transition for the meta text when the overlay appears on hover.'),
					'values' => array(
						'' => JText::_('None'),
						'fade' => JText::_('Fade'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
						'slide-top-small' => JText::_('Slide Top Small'),
						'slide-bottom-small' => JText::_('Slide Bottom Small'),
						'slide-left-small' => JText::_('Slide Left Small'),
						'slide-right-small' => JText::_('Slide Right Small'),
						'slide-top-medium' => JText::_('Slide Top Medium'),
						'slide-bottom-medium' => JText::_('Slide Bottom Medium'),
						'slide-left-medium' => JText::_('Slide Left Medium'),
						'slide-right-medium' => JText::_('Slide Right Medium'),
						'slide-top' => JText::_('Slide Top 100%'),
						'slide-bottom' => JText::_('Slide Bottom 100%'),
						'slide-left' => JText::_('Slide Left 100%'),
						'slide-right' => JText::_('Slide Right 100%'),
					),
					'std' => '',
					'depends' => array(
						array('overlay_on_hover', '=', 1),
						array('overlay_mode', '!=', 'icon'),
					)
				),

				'meta_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select a predefined meta text style, including color, size and font-family'),
					'values' => array(
						'' => JText::_('None'),
						'text-meta' => JText::_('Meta'),
						'heading-2xlarge' => JText::_('2XLarge'),
						'heading-xlarge' => JText::_('XLarge'),
						'heading-large' => JText::_('Large'),
						'heading-medium' => JText::_('Medium'),
						'heading-small' => JText::_('Small'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => '',
				),
				'meta_font_family'=>array(
					'type'=>'fonts',
					'title'=>JText::_('Font Family'),
					'selector'=> array(
						'type'=>'font',
						'font'=>'{{ VALUE }}',
						'css'=>'.ui-meta { font-family: {{ VALUE }}; }',
					)
				),
				'meta_color' => array(
					'type' => 'select',
					'title' => JText::_('Predefined Color'),
					'desc' => JText::_('Select the predefined meta text color.'),
					'values' => array(
						'' => JText::_('None'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'success' => JText::_('Success'),
						'warning' => JText::_('Warning'),
						'danger' => JText::_('Danger'),
					),
					'std' => '',
				),
				'custom_meta_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Custom Color'),
					'depends' => array(
						array('meta_color', '=', '')
					),
				),
				'meta_alignment' => array(
					'type' => 'select',
					'title' => JText::_('Alignment'),
					'desc' => JText::_('Align the meta text above or below the title.'),
					'values' => array(
						'top' => JText::_('Above Title'),
						'' => JText::_('Below Title'),
						'content' => JText::_('Below Content'),
					),
					'std' => '',
				),
				'meta_text_transform' => array(
					'type' => 'select',
					'title' => JText::_('Transform'),
					'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uppercase' => JText::_('Uppercase'),
						'capitalize' => JText::_('Capitalize'),
						'lowercase' => JText::_('Lowercase'),
					),
					'std' => '',
				),
				'meta_element' => array(
					'type' => 'select',
					'title' => JText::_('HTML Element'),
					'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
					'values' => array(
						'h1' => JText::_('h1'),
						'h2' => JText::_('h2'),
						'h3' => JText::_('h3'),
						'h4' => JText::_('h4'),
						'h5' => JText::_('h5'),
						'h6' => JText::_('h6'),
						'div' => JText::_('div'),
					),
					'std' => 'div',
				),
				'meta_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'separator_content_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Content'),
				),
				'content_transition' => array(
					'type' => 'select',
					'title' => JText::_('Transition'),
					'desc' => JText::_('Select a transition for the content when the overlay appears on hover.'),
					'values' => array(
						'' => JText::_('None'),
						'fade' => JText::_('Fade'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
						'slide-top-small' => JText::_('Slide Top Small'),
						'slide-bottom-small' => JText::_('Slide Bottom Small'),
						'slide-left-small' => JText::_('Slide Left Small'),
						'slide-right-small' => JText::_('Slide Right Small'),
						'slide-top-medium' => JText::_('Slide Top Medium'),
						'slide-bottom-medium' => JText::_('Slide Bottom Medium'),
						'slide-left-medium' => JText::_('Slide Left Medium'),
						'slide-right-medium' => JText::_('Slide Right Medium'),
						'slide-top' => JText::_('Slide Top 100%'),
						'slide-bottom' => JText::_('Slide Bottom 100%'),
						'slide-left' => JText::_('Slide Left 100%'),
						'slide-right' => JText::_('Slide Right 100%'),
					),
					'std' => '',
					'depends' => array(
						array('overlay_on_hover', '=', 1),
						array('overlay_mode', '!=', 'icon'),
					)
				),
				'content_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select a predefined meta text style, including color, size and font-family'),
					'values' => array(
						'' => JText::_('None'),
						'text-lead' => JText::_('Lead'),
						'text-meta' => JText::_('Meta'),
					),
					'std' => '',
				),
				'content_font_family'=>array(
					'type'=>'fonts',
					'title'=>JText::_('Font Family'),
					'selector'=> array(
						'type'=>'font',
						'font'=>'{{ VALUE }}',
						'css'=>'.ui-content { font-family: {{ VALUE }}; }',
					)
				),
				'content_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Color'),
				),
				'content_text_transform' => array(
					'type' => 'select',
					'title' => JText::_('Transform'),
					'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uppercase' => JText::_('Uppercase'),
						'capitalize' => JText::_('Capitalize'),
						'lowercase' => JText::_('Lowercase'),
					),
					'std' => '',
				),
				'content_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'separator_link_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Link'),
				),
				'button_title' => array(
					'type' => 'text',
					'title' => JText::_('Text'),
					'placeholder' => 'Read more',
					'std' => 'Read More',
				),
				'link_new_tab' => array(
					'type' => 'select',
					'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
					'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
					'values' => array(
						'' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
						'_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
					),
				),
				'button_transition' => array(
					'type' => 'select',
					'title' => JText::_('Transition'),
					'desc' => JText::_('Select a transition for the link when the overlay appears on hover.'),
					'values' => array(
						'' => JText::_('None'),
						'fade' => JText::_('Fade'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
						'slide-top-small' => JText::_('Slide Top Small'),
						'slide-bottom-small' => JText::_('Slide Bottom Small'),
						'slide-left-small' => JText::_('Slide Left Small'),
						'slide-right-small' => JText::_('Slide Right Small'),
						'slide-top-medium' => JText::_('Slide Top Medium'),
						'slide-bottom-medium' => JText::_('Slide Bottom Medium'),
						'slide-left-medium' => JText::_('Slide Left Medium'),
						'slide-right-medium' => JText::_('Slide Right Medium'),
						'slide-top' => JText::_('Slide Top 100%'),
						'slide-bottom' => JText::_('Slide Bottom 100%'),
						'slide-left' => JText::_('Slide Left 100%'),
						'slide-right' => JText::_('Slide Right 100%'),
					),
					'std' => '',
					'depends' => array(
						array('overlay_on_hover', '=', 1),
						array('overlay_mode', '!=', 'icon'),
					)
				),

				'button_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Set the button style.'),
					'values' => array(
						'' => JText::_('Button Default'),
						'primary' => JText::_('Button Primary'),
						'secondary' => JText::_('Button Secondary'),
						'danger' => JText::_('Button Danger'),
						'text' => JText::_('Button Text'),
						'link' => JText::_('Link'),
						'link-muted' => JText::_('Link Muted'),
						'link-text' => JText::_('Link Text'),
						'custom' => JText::_('Custom'),
					),
					'std' => '',
				),
				'separator_button_custom_options' => array(
					'type' => 'separator',
					'title' => JText::_('Custom Button Style'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_font_family'=>array(
					'type'=>'fonts',
					'title'=>JText::_('Font Family'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					),
					'selector'=> array(
						'type'=>'font',
						'font'=>'{{ VALUE }}',
						'css'=>'.uk-button-custom { font-family: {{ VALUE }}; }',
					)
				),
				'button_background' => array(
					'type' => 'color',
					'title' => JText::_('Background Color'),
					'std' => '#1e87f0',
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Button Color'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_background_hover' => array(
					'type' => 'color',
					'title' => JText::_('Hover Background Color'),
					'std' => '#1e87f0',
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_hover_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Hover Button Color'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_size' => array(
					'type' => 'select',
					'title' => JText::_('Button Size'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'large' => JText::_('Large'),
					),
					'std' => '',
				),
				'button_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'separator_general_options' => array(
					'type' => 'separator',
					'title' => JText::_('General'),
				),
				'addon_margin' => array(
					'type' => 'select',
					'title' => JText::_('Margin'),
					'desc' => JText::_('Set the vertical margin. Note: The first element\'s top margin and the last element\'s bottom margin are always removed. Define those in the grid settings instead.'),
					'values' => array(
						'' => JText::_('Keep existing'),
						'small' => JText::_('Small'),
						'default' => JText::_('Default'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove-vertical' => JText::_('None'),
					),
					'std' => '',
				),
				'addon_max_width' => array(
					'type' => 'select',
					'title' => JText::_('Max Width'),
					'desc' => JText::_('Set the maximum content width.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'2xlarge' => JText::_('2X-Large'),
					),
					'std' => '',
				),
				'addon_max_width_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Max Width Breakpoint'),
					'desc' => JText::_('Define the device width from which the element\'s max-width will apply.'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone Landscape)'),
						'm' => JText::_('Medium (Tablet Landscape)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => '',
					'depends' => array(array('addon_max_width', '!=', '')),
				),
				'block_align'=>array(
					'type'=>'select',
					'title'=>JText::_('Block Alignment'),
					'desc'=>JText::_('Define the alignment in case the container exceeds the element\'s max-width.'),
					'values'=>array(
						''=>JText::_('Left'),
						'center'=>JText::_('Center'),
						'right'=>JText::_('Right'),
					),
					'std'=>'',
					'depends'=>array(array('addon_max_width', '!=', '')),
				),
				'block_align_breakpoint'=>array(
					'type'=>'select',
					'title'=>JText::_('Block Alignment Breakpoint'),
					'desc'=>JText::_('Define the device width from which the alignment will apply.'),
					'values'=>array(
						''=>JText::_('Always'),
						's'=>JText::_('Small (Phone Landscape)'),
						'm'=>JText::_('Medium (Tablet Landscape)'),
						'l'=>JText::_('Large (Desktop)'),
						'xl'=>JText::_('X-Large (Large Screens)'),
					),
					'std'=>'',
					'depends'=>array(array('addon_max_width', '!=', '')),
				),
				'block_align_fallback'=>array(
					'type'=>'select',
					'title'=>JText::_('Block Alignment Fallback'),
					'desc'=>JText::_('Define the alignment in case the container exceeds the element\'s max-width.'),
					'values'=>array(
						''=>JText::_('Left'),
						'center'=>JText::_('Center'),
						'right'=>JText::_('Right'),
					),
					'std'=>'',
					'depends'=>array(
						array('addon_max_width', '!=', ''),
						array('block_align_breakpoint', '!=', '')
					),
				),
				'alignment' => array(
					'type' => 'select',
					'title' => JText::_('Text Alignment'),
					'desc' => JText::_('Center, left and right alignment.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uk-text-left' => JText::_('Left'),
						'uk-text-center' => JText::_('Center'),
						'uk-text-right' => JText::_('Right'),
						'uk-text-justify' => JText::_('Justify'),
					),
					'std' => '',
				),
				'text_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Text Alignment Breakpoint'),
					'desc' => JText::_('Display the text alignment only on this device width and larger'),
					'values' => array(
						'' => 'Always',
						's' => 'Small (Phone Landscape)',
						'm' => 'Medium (Tablet Landscape)',
						'l' => 'Large (Desktop)',
						'xl' => 'X-Large (Large Screens)',
					),
					'std' => '',
					'depends' => array(array('alignment', '!=', '')),
				),
				'text_alignment_fallback' => array(
					'type' => 'select',
					'title' => JText::_('Text Alignment Fallback'),
					'desc' => JText::_('Define an alignment fallback for device widths below the breakpoint'),
					'values' => array(
						'' => 'Inherit',
						'left' => 'Left',
						'center' => 'Center',
						'right' => 'Right',
						'justify' => 'Justify',
					),
					'std' => '',
					'depends' => array(
						array('text_breakpoint', '!=', ''),
						array('alignment', '!=', '')
					),
				),
				'animation' => array(
					'type' => 'select',
					'title' => JText::_('Animation'),
					'desc' => JText::_('A collection of smooth animations to use within your page.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'fade' => JText::_('Fade'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
						'slide-top-small' => JText::_('Slide Top Small'),
						'slide-bottom-small' => JText::_('Slide Bottom Small'),
						'slide-left-small' => JText::_('Slide Left Small'),
						'slide-right-small' => JText::_('Slide Right Small'),
						'slide-top-medium' => JText::_('Slide Top Medium'),
						'slide-bottom-medium' => JText::_('Slide Bottom Medium'),
						'slide-left-medium' => JText::_('Slide Left Medium'),
						'slide-right-medium' => JText::_('Slide Right Medium'),
						'slide-top' => JText::_('Slide Top 100%'),
						'slide-bottom' => JText::_('Slide Bottom 100%'),
						'slide-left' => JText::_('Slide Left 100%'),
						'slide-right' => JText::_('Slide Right 100%'),
						'parallax' => JText::_('Parallax'),
					),
					'std' => '',
				),
				'animation_repeat' => array(
					'type' => 'checkbox',
					'title' => JText::_('Repeat Animation'),
					'desc' => JText::_('Applies the animation class every time the element is in view'),
					'std' => 0,
					'depends' => array(
						array('animation', '!=', ''),
						array('animation', '!=', 'parallax'),
					),
				),
				'delay_element_animations' => array(
					'type' => 'checkbox',
					'title' => JText::_('Delay Element Animations'),
					'desc' => JText::_('Delay element animations so that animations are slightly delayed and don\'t play all at the same time. Slide animations can come into effect with a fixed offset or at 100% of the element\’s own size.'),
					'std' => 0,
					'depends' => array(
						array('animation', '!=', ''),
						array('animation', '!=', 'parallax'),
					),
				),
				'separator_parallax_options' => array(
					'type' => 'separator',
					'title' => JText::_('Customizing Parallax'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'horizontal_start' => array(
					'type' => 'slider',
					'title' => JText::_('Horizontal Start'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the horizontal position (translateX) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'horizontal_end' => array(
					'type' => 'slider',
					'title' => JText::_('Horizontal End'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the horizontal position (translateX) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'vertical_start' => array(
					'type' => 'slider',
					'title' => JText::_('Vertical Start'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the vertical position (translateY) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'vertical_end' => array(
					'type' => 'slider',
					'title' => JText::_('Vertical End'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the vertical position (translateY) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'scale_start' => array(
					'type' => 'slider',
					'title' => JText::_('Scale Start'),
					'min' => 50,
					'max' => 200,
					'desc' => JText::_('Animate the scaling. Min: 50, Max: 200 =>  100 means 100% scale, 200 means 200% scale, and 50 means 50% scale.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'scale_end' => array(
					'type' => 'slider',
					'title' => JText::_('Scale End'),
					'min' => 50,
					'max' => 200,
					'desc' => JText::_('Animate the scaling. Min: 50, Max: 200 =>  100 means 100% scale, 200 means 200% scale, and 50 means 50% scale.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'rotate_start' => array(
					'type' => 'slider',
					'title' => JText::_('Rotate Start'),
					'min' => 0,
					'max' => 360,
					'desc' => JText::_('Animate the rotation clockwise in degrees.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'rotate_end' => array(
					'type' => 'slider',
					'title' => JText::_('Rotate End'),
					'min' => 0,
					'max' => 360,
					'desc' => JText::_('Animate the rotation clockwise in degrees.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'opacity_start' => array(
					'type' => 'slider',
					'title' => JText::_('Opacity Start'),
					'min' => 0,
					'max' => 100,
					'desc' => JText::_('Animate the opacity. 100 means 100% opacity, and 0 means 0% opacity.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'opacity_end' => array(
					'type' => 'slider',
					'title' => JText::_('Opacity End'),
					'min' => 0,
					'max' => 100,
					'desc' => JText::_('Animate the opacity. 100 means 100% opacity, and 0 means 0% opacity.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'easing' => array(
					'type' => 'slider',
					'title' => JText::_('Easing'),
					'min' => -200,
					'max' => 200,
					'desc' => JText::_('Set the animation easing. A value below 100 is faster in the beginning and slower towards the end while a value above 100 behaves inversely.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'viewport' => array(
					'type' => 'slider',
					'title' => JText::_('Viewport'),
					'min' => 10,
					'max' => 100,
					'desc' => JText::_('Set the animation end point relative to viewport height, e.g. 50 for 50% of the viewport'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'parallax_target' => array(
					'type' => 'checkbox',
					'title' => JText::_('Target'),
					'desc' => JText::_('Animate the element as long as the section is visible.'),
					'std' => 0,
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'parallax_zindex' => array(
					'type' => 'checkbox',
					'title' => JText::_('Z Index'),
					'desc' => JText::_('Set a higher stacking order.'),
					'std' => 0,
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Breakpoint'),
					'desc' => JText::_('Display the parallax effect only on this device width and larger. It is useful to disable the parallax animation on small viewports.'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone)'),
						'm' => JText::_('Medium (Tablet)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => '',
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'visibility' => array(
					'type' => 'select',
					'title' => JText::_('Visibility'),
					'desc' => JText::_('Display the element only on this device width and larger.'),
					'values' => array(
						'' => JText::_('Always'),
						'uk-visible@s' => JText::_('Small (Phone Landscape)'),
						'uk-visible@m' => JText::_('Medium (Tablet Landscape)'),
						'uk-visible@l' => JText::_('Large (Desktop)'),
						'uk-visible@xl' => JText::_('X-Large (Large Screens)'),
						'uk-hidden@s' => JText::_('Hidden Small (Phone Landscape)'),
						'uk-hidden@m' => JText::_('Hidden Medium (Tablet Landscape)'),
						'uk-hidden@l' => JText::_('Hidden Large (Desktop)'),
						'uk-hidden@xl' => JText::_('Hidden X-Large (Large Screens)'),
					),
					'std' => '',
				),
				'class' => array(
					'type' => 'text',
					'title' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std' => '',
				),
			)
		),
	)
);
