<?php

/**
 * @package   Astroid Framework
 * @author    JoomDev https://www.joomdev.com
 * @copyright Copyright (C) 2009 - 2019 JoomDev.
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 * 	DO NOT MODIFY THIS FILE DIRECTLY AS IT WILL BE OVERWRITTEN IN THE NEXT UPDATE
 *  You can easily override all files under /frontend/ folder.
 * 	Just copy the file to ROOT/templates/YOURTEMPLATE/html/frontend/ folder to create and override
 */
// No direct access.
defined('_JEXEC') or die;

use Astroid\Helper;
use Astroid\Framework;
$template = Framework::getTemplate();
$params = $template->getParams();
$document = Framework::getDocument();

// Color option
$styles = [];
$header_background_color = $params->get('header_bg', '');
$footer_background_color = $params->get('footer_background_color', '');

if (!empty($header_background_color)) {
    $styles[]    = '.top-bar .container:before, .top-bar .container:after {background-color:'.$header_background_color.';}';
}

if (!empty($footer_background_color)) {
    $styles[]    = '.astroid-footer-section .container:before, .astroid-footer-section .container:after {background-color:'.$footer_background_color.';}';
}

$body_container_background = $params->get('body_container_background', '');
if (!empty($body_container_background)) {
    $styles[] = '.sidebar .moduletable, .blog article .box-content, .item-detail-container, .author-wrap, .list-group-item, .page-link { background-color: ' . $body_container_background . ';}';
}

$document->addStyledeclaration(implode('', $styles));