<?php
/**
 * @name		Slider CK
 * @package		com_sliderck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

// No direct access
defined('_JEXEC') or die;
jimport('joomla.application.component.helper');

class SliderckController extends JControllerLegacy
{
	static $releaseNotes;

	static $currentVersion;

	public function display($cachable = false, $urlparams = false)
	{
		$input	= JFactory::getApplication()->input;
		$view	= $input->get('view', 'about');
		$input->set('view', $view);

		parent::display();

		return $this;
	}

	function loadUpdatecheckJs() {
		$js_checking = 'jQuery(document).ready(function (){
				jQuery(\'.sliderckchecking\').each(function(i ,el){
					var isbadge = jQuery(el).hasClass(\'isbadgeck\') ? 1 : 0;
					jQuery.ajax({
						type: "POST",
						url: \'' . JUri::root(true) . '/administrator/index.php?option=com_sliderck&task=checkUpdate\',
						data: {
							isbadge : isbadge
						}
					}).done(function(response) {
						response = response.trim();
						if ( response.substring(0,7).toLowerCase() == \'error\' ) {
							// alert(response);
							// show_ckmodal(response);
						} else {
							jQuery(el).append(response);
						}
					}).fail(function() {
						// alert(Joomla.JText._(\'CK_FAILED\', \'Failed\'));
					});
				});
			});';
		$doc = JFactory::getDocument();
		$doc->addScriptDeclaration($js_checking);
	}

	/**
	* Check updates for the component, module, or plugins
	*/
	public function checkUpdate() {
		$input = JFactory::getApplication()->input;
		$isBadge = $input->get('isbadge', 0, 'int');
		$latest_version = self::getLatestVersion();
		$update_status = '';
		if (self::isOutdated()) {
			if ($isBadge) {
				$update_status = '<span class="badge-alertck">' . JText::_('CK_UPDATE_NOTIFICATION') . '</span>';
			} else {
				$update_status = '<p class="alert alert-warning">' . JText::_('CK_IS_OUTDATED') . ' : <b>' . $latest_version . '</b></p>';
			}
		} else {
			// $update_status = '<p class="alert alert-success">' . JText::_('CK_IS_UPTODATE') . '</p>';
		}

		echo $update_status;
		exit();
	}

	/**
	 * Check if a new version is available
	 * 
	 * @return false, or the latest version
	 */
	public static function getLatestVersion() {
		$releaseNotes = self::getReleaseNotes();
		$latest_version = false;
		if ($releaseNotes) {
			// $test_version = preg_match('/\*(.*?)\n/', $releaseNotes, $results);
			// $latest_version = trim($results[1]);
			$latest_version = $releaseNotes->version;
		}

		return $latest_version;
	}
	
	/*
	 * Get a variable from the manifest file.
	 * 
	 * @return the current version
	 */
	public static function getCurrentVersion() {
		if (! self::$currentVersion) {
			// get the version installed
			self::$currentVersion = false;
			$file_url = JPATH_SITE .'/administrator/components/com_sliderck/sliderck.xml';
			if (! $xml_installed = JFactory::getXML($file_url)) {
				// die;
			} else {
				self::$currentVersion = (string)$xml_installed->version;
			}
		}

		return self::$currentVersion;
	}

	/**
	 * Get the release notes content
	 * 
	 * @return false or the file content
	 */
	public static function getReleaseNotes() { 
		if (! self::$releaseNotes) {
			// $url = 'http://update.joomlack.fr/sliderck_update.txt';
			$url = 'http://update.joomlack.fr/com_sliderck_notes.json';
			$releaseNotes = @file_get_contents($url);
			self::$releaseNotes = json_decode($releaseNotes);
		}
		
		return self::$releaseNotes;
	}

	/**
	 * Format the release notes in html
	 */
	public static function displayReleaseNotes() {
		$releaseNotes = self::getReleaseNotes();
		if (! isset($releaseNotes->releasenotes)) return;

		if (self::isOutdated()) {
			echo '<br /><p style="text-transform:uppercase;text-decoration: underline;">Release notes :</p><br />';
		}
		foreach ($releaseNotes->releasenotes as $i => $v) {
			// stop at the current version notes
			if (version_compare($i, self::getCurrentVersion() ) <= 0) break;

			echo '<h4>VERSION : ' . $i . ' - ' . $v->date . '</h4>';
			echo '<ul>';
				foreach ($v->notes as $n) {
					echo '<li>' . htmlspecialchars($n) . '</li>';
				}
			echo '</ul>';
		}
	}

	/**
	 * Check if you have the latest version
	 * 
	 * @return boolean, true if outdated
	 */
	public static function isOutdated() {
		return version_compare(self::getLatestVersion(), self::getCurrentVersion() ) > 0;
	}
	
	/*
	 * Loads the image and the label edition from a folder
	 */
	public function ajaxLoadLabelsFromFolder() {
		require_once JPATH_ROOT . '/administrator/components/com_sliderck/helpers/source/folder.php';
		$input	= JFactory::getApplication()->input;
		$moduleId = $input->get('moduleId', '', 'int');
		$path = $input->get('path', '', 'string');
		/*
		$filetypes = array('.jpg', '.jpeg', '.png', '.gif', '.tiff', '.JPG', '.JPEG', '.PNG', '.GIF', '.TIFF', '.ico');
		$items = JFolder::files(JPATH_SITE . '/' . $path, implode('|', $filetypes), $recurse = false, $fullpath = false);

		natcasesort($files);
		$path = SliderckHelper::formatPath($path);*/
		$module = $this->getModuleFromId($moduleId);
		$params = isset($module->params) ? new JRegistry($module->params) :  new JRegistry();
		$items = SliderckHelpersourceFolder::getItems($params, $path);

		// render the html
		$this->renderLabelsFromFolder($path, $items);

		exit();
	}
	
	private function renderLabelsFromFolder($path, $files) {
		if (! $files) {
			echo '<p>' . JText::_('CK_NO_FILES_TO_SHOW') . '</p>';
			return;
		}
		$i = 1;
		foreach ($files as $file) {
		?>
<div class="ckfile" data-index="<?php echo $i ?>" style="background-image: url('<?php echo JUri::root(true) . '/' . $file->path ?>')" data-file="<?php echo $file->path ?>">
	
</div>
		<?php
		$i++;
		}
	}
	
	private function getModuleFromId($id) {
		$db = JFactory::getDbo();

		$query = $db->getQuery(true)
			->select('m.id, m.title, m.module, m.position, m.content, m.showtitle, m.params, mm.menuid')
			->from('#__modules AS m')
			->join('LEFT', '#__modules_menu AS mm ON mm.moduleid = m.id')
			->where('m.published = 1')

			->join('LEFT', '#__extensions AS e ON e.element = m.module AND e.client_id = m.client_id')
			->where('module = \'mod_sliderck\'')
			->where('e.enabled = 1');
		// Set the query
		$db->setQuery($query);

		try
		{
			$module = $db->loadObject();
		}
		catch (RuntimeException $e)
		{
			JLog::add(JText::sprintf('JLIB_APPLICATION_ERROR_MODULE_LOAD', $e->getMessage()), JLog::WARNING, 'jerror');

			return null;
		}

		return $module;
	}
	
	/*
	 * Loads the image and the label edition from a folder
	 */
	public function ajaxLoadLabelsFile() {
		require_once JPATH_ROOT . '/administrator/components/com_sliderck/helpers/source/folder.php';
		$input	= JFactory::getApplication()->input;
		$path = $input->get('path', '', 'string');
		// outputs the heading
		echo '<script src="' . JUri::root(true) . '/media/jui/js/jquery.min.js?e447970ebe9768673a45c3459f744eb0"></script>';
		echo '<script src="' . JUri::root(true) . '/media/com_sliderck/assets/jquery-ui.min.js"></script>';
		echo '<div id="labelseditor">';
		echo '<div class="ckheader">'
					. '<div class="col ckmove">' . JText::_('CK_ORDERING') . '</div>'
					. '<div class="col ckimage">' . JText::_('CK_IMAGE') . '</div>'
					. '<div class="col">' . JText::_('CK_FILE') . '</div>'
					. '<div class="col">' . JText::_('CK_TITLE') . '</div>'
					. '<div class="col">' . JText::_('CK_DESCRIPTION') . '</div>'
					. '<div class="col">' . JText::_('CK_LINK') . '</div>'
				. '</div>';

		$params = new JRegistry();
		$items = SliderckHelpersourceFolder::getItems($params, $path);
		
		$images = Array();
		foreach ($items as $item) {
			$filename = explode('/', $item->path);
			$filename = end($filename);
			$images[] = $filename;
		}

		$i = 0;
		$labels = Array();
		if (file_exists(JPATH_SITE . '/' . $path . '/labels.txt')) {
			$labels = JFile::read(JPATH_SITE . '/' . $path . '/labels.txt');
			$lines = explode("\n", $labels);
			foreach ($lines as $line) {
				$line = trim($line);
				if (!$line) continue;
				$t = explode('|', $line);
				$image = isset($t[0]) ? $t[0] : '';
				if (! $image) continue;
				$title = isset($t[1]) ? $t[1] : '';
				$desc = isset($t[2]) ? $t[2] : '';
				$link = isset($t[3]) ? $t[3] : '';
				if (in_array($image, $images)) {
					$key = array_search($image, $images);
					unset($images[$key]);
					$this->renderLabelEdition($path, $image, $i, $title, $desc, $link);
					$i++;
				}

				
			}
		}

		
		foreach ($images as $image) {
			$this->renderLabelEdition($path, $image, $i, $title = '', $desc = '', $link = '');
			$i++;
		}
		echo '</div>';
		exit();
	}

	/*
	 * Output the html code for the label edition
	 */
	private function renderLabelEdition($path, $image, $i, $title, $desc, $link) {
		echo '<div class="ckrow">'
					. '<div class="col ckmove">&nbsp;</div>'
					. '<div class="col ckfile" style="background-image: url(\'' . JUri::root(true) . '/' . $path . '/' . $image . '\');" ></div>'
					. '<div class="col"><input class="labelimage" type="text" value="' . utf8_encode($image) . '" disabled /></div>'
					. '<div class="col"><input class="labeltitle" type="text" value="' . utf8_encode($title) . '" /></div>'
					. '<div class="col"><input class="labeldesc" type="text" value="' . utf8_encode($desc) . '" /></div>'
					. '<div class="col input-append"><input id="labellink'.$i.'" class="labellink" type="text" value="' . utf8_encode($link) . '" /><button class="btn" onclick="CKBox.open({url: \''.JUri::root(true).'/administrator/index.php?option=com_sliderck&view=menus&tmpl=component&fieldid=labellink'.$i.'\', id:\'ckmenusmodal\', style: {padding: \'10px\'} })">' . JText::_('CK_SELECT') . '</button></div>'
				. '</div>';
	}

	/*
	 * Write the labels.txt file in the folder
	 */
	public function ajaxWriteLabelsFile() {
		$input	= JFactory::getApplication()->input;
		$path = $input->get('path', '', 'string');
		$labels = utf8_decode($input->get('labels', '', 'html'));
		$labelsFile = JPATH_SITE . '/' . $path . '/labels.txt';
//		JFile::copy($labelsFile, JPATH_SITE . '/' . $path . '/labels.bak');
		echo JFile::write($labelsFile, $labels);
		exit();
	}

	/*
	 * Generate the CSS styles from the settings
	 */
	public function ajaxRenderCss() {
		$input	= JFactory::getApplication()->input;
		$fields = $input->get('fields', '', 'raw');
		$fields = json_decode($fields);
		$customstyles = stripslashes( $input->get('customstyles', '', 'string'));
		$customstyles = json_decode($customstyles);
		$customcss = $input->get('customcss', '', 'html');

		$css = $this->renderCss($fields, $customstyles);
		echo $css . $customcss;
		exit();
	}

	/*
	 * Render the CSS from the settings
	 */
	public function renderCss($fields, $customstyles) {
		include_once SLIDERCK_ADMIN_PATH . '/helpers/ckstyles.php';
		$ckstyles = new CKStyles();
		$css = $ckstyles->create($fields, $customstyles);

		return $css;
	}

	/**
	 * Get the file and store it on the server
	 * 
	 * @return mixed, the method return
	 */
	public function ajaxAddPicture() {
		require_once SLIDERCK_ADMIN_PATH . '/helpers/ckbrowse.php';
		CKBrowse::ajaxAddPicture();
	}
	
	/*
	 * Generate the CSS styles from the settings
	 */
	public function ajaxSaveStyles() {
		// security check
		if (! SliderckHelper::getAjaxToken()) {
			exit();
		}
		// Import Table
		JTable::addIncludePath(SLIDERCK_ADMIN_PATH . '/tables');
		$row = JTable::getInstance('Styles', 'SliderckTable');

		$input	= JFactory::getApplication()->input;

		$fields = $input->get('fields', '', 'raw');
		$id = $input->get('id', 0, 'int');
		$name = $input->get('name', '', 'string');
		if (! $name) $name = 'style' . $id;
		$layoutcss = trim($input->get('layoutcss', '', 'html'));

		// load the module
		$row->load( (int) $id ); 
		$row->params = $fields;
		$row->name = $name;
		$row->layoutcss = $layoutcss;
		if (!$row->store()) {
			echo "{'result': '0', 'id': '" . $row->id . "', 'message': 'Error : Can not save the Styles !'}";
			echo($this->_db->getErrorMsg());
			die;
		}
		echo '{"result": "1", "id": "' . $row->id . '", "message": "Styles saved successfully"}';
		exit();
	}

	/**
	 * Ajax method to save the json data into the .mmck file
	 *
	 * @return  boolean - true on success for the file creation
	 *
	 */
	function exportParams() {
		$input = JFactory::getApplication()->input;
		// create a backup file with all fields stored in it
		$fields = $input->get('jsonfields', '', 'string');
		$backupfile_path = SLIDERCK_ADMIN_PATH . '/export/exportParamsSliderckStyle'. $input->get('styleid',0,'int') .'.mmck';
		if (JFile::write($backupfile_path, $fields)) {
			echo '1';
		} else {
			echo '0';
		}

		exit();
	}
	
	/**
	 * Ajax method to import the .mmck file into the interface
	 *
	 * @return  boolean - true on success for the file creation
	 *
	 */
	function uploadParamsFile() {
		$app = JFactory::getApplication();
		$input = $app->input;
		$file = $input->files->get('file', '', 'array');
		if (!is_array($file))
			exit();

		$filename = JFile::makeSafe($file['name']);

		// check if the file exists
		if (JFile::getExt($filename) != 'mmck') {
			$msg = JText::_('CK_NOT_MMCK_FILE', true);
			echo json_encode(array('error'=> $msg));
			exit();
		}

		//Set up the source and destination of the file
		$src = $file['tmp_name'];

		// check if the file exists
		if (!$src || !JFile::exists($src)) {
			$msg = JText::_('CK_FILE_NOT_EXISTS', true);
			echo json_encode(array('error'=> $msg));
			exit();
		}

		// read the file
		if (!$filecontent = JFile::read($src)) {
			$msg = JText::_('CK_UNABLE_READ_FILE', true);
			echo json_encode(array('error'=> $msg));
			exit();
		}

		// replace vars to allow data to be moved from another server
		$filecontent = str_replace("|URIROOT|", JUri::root(true), $filecontent);
//		$filecontent = str_replace("|qq|", '"', $filecontent);

//		echo $filecontent;
		echo json_encode(array('data'=> $filecontent));
		exit();
	}

	function ajaxShowMenuItems() {
		// security check
		if (! SliderckHelper::getAjaxToken()) {
			exit();
		}

		$app = JFactory::getApplication();
		$input = $app->input;
		$parentId = $input->get('parentid', 0, 'int');
		$menutype = $input->get('menutype', '', 'string');

		$model = $this->getModel('Menus', '', array());
		$items = $model->getChildrenItems($menutype, $parentId);

		$links = array();
		$imagespath = SLIDERCK_MEDIA_URI .'/images/';
		?>
		<div class="cksubfolder">
		<?php
		foreach ($items as $item) {
			$aliasId = $item->id;
			if ($item->type == 'alias') {
				$itemParams = new JRegistry($item->params);
				$aliasId = $itemParams->get('aliasoptions', 0);
			}
			$Itemid = substr($item->link,-7,7) == 'Itemid=' ? $aliasId : '&Itemid=' . $aliasId;
		?>
			<div class="ckfoldertree parent">
				<div class="ckfoldertreetoggler <?php if ($item->rgt - $item->lft <= 1) { echo 'empty'; } ?>" onclick="ckToggleTreeSub(this, <?php echo $item->id ?>)" data-menutype="<?php echo $item->menutype; ?>"></div>
				<div class="ckfoldertreename hasTip" title="<?php echo $item->link . $Itemid ?>" onclick="ckSetMenuItemUrl('<?php echo $item->link . $Itemid ?>')"><img src="<?php echo $imagespath ?>folder.png" /><?php echo $item->title; ?></div>
			</div>
		<?php
		}
		?>
		</div>
		<?php
		exit;
	}
}