<?php
/**
 * @name		Slider CK
 * @package		com_sliderck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */
 
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

/**
 * View class for a list of Maximenuck.
 */
class SliderckViewStyles extends JViewLegacy {

	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->state = $this->get('State');
		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		require_once JPATH_COMPONENT . '/helpers/sliderck.php';

		// Load the left sidebar.
		SliderckHelper::addSubmenu();

		// Load the title
		JToolBarHelper::title(JText::_('COM_SLIDERCK') . ' - ' . JText::_('CK_STYLES_LIST'), 'logo_sliderck_large.png');

		if (JFactory::getApplication()->isAdmin()) $this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Get the list of sliderck styles
	 */
	/*private function getStyles() {
		// Create a new query object.
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('a.*');
		$query->from($db->quoteName('#__sliderck_styles') . ' AS a');
		$query->where('(a.state IN (0, 1))');

		// Reset the query using our newly populated query object.
		$db->setQuery($query);

		// Load the results as a list of stdClass objects (see later for more options on retrieving data).
		$results = $db->loadObjectList();

		return $results;
	}*/
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar() {
		SliderckHelper::loadCkbox();

		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		$state = $this->get('State');
		$canDo = SliderckHelper::getActions($state->get('filter.category_id'));

		//Check if the form exists before showing the add/edit buttons
		$formPath = JPATH_COMPONENT_ADMINISTRATOR . '/views/style';
		if (file_exists($formPath)) {

			if ($canDo->get('core.create')) {
//				JToolBarHelper::addNew('style.add', 'JTOOLBAR_NEW');
				// Render the popup button
				$html = '<button class="btn btn-small btn-success" onclick="CKBox.open({handler:\'iframe\', fullscreen: true, url:\'' . JUri::root(true) . '/administrator/index.php?option=com_sliderck&view=style&layout=modal&tmpl=component&id=0\'})">
						<span class="icon-new icon-white"></span>
						' . JText::_('JTOOLBAR_NEW') . '
						</button>';
				$bar->appendButton('Custom', $html);
			}

			if ($canDo->get('core.edit')) {
//				JToolBarHelper::editList('style.edit', 'JTOOLBAR_EDIT');
				JToolBarHelper::custom('style.copy', 'copy', 'copy', 'CK_COPY');
			}
		}

		if ($canDo->get('core.edit.state')) {

			if (isset($this->items[0]->state)) {
				JToolBarHelper::divider();
			} else {
				//If this component does not use state then show a direct delete button as we can not trash
				JToolBarHelper::trash('styles.delete');
			}



			if (isset($this->items[0]->state)) {
				JToolBarHelper::divider();
			}
		}

		//Show trash and delete for components that uses the state field
		if (isset($this->items[0]->state)) {
			if ($state->get('filter.state') == -2 && $canDo->get('core.delete')) {
				JToolBarHelper::divider();
				JToolBarHelper::trash('styles.delete', 'JTOOLBAR_DELETE');
			} else if ($canDo->get('core.edit.state')) {
				JToolBarHelper::trash('styles.trash', 'JTOOLBAR_DELETE');
				JToolBarHelper::divider();
			}
		}

		if ($canDo->get('core.admin')) {
			JToolBarHelper::preferences('com_sliderck');
		}
	}
}
