<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_linguise
 *
 * @copyright   Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

/**
 * Controller for a single linguise
 *
 * @since  1.6
 */
class LinguiseControllerLinguise extends JControllerForm
{
	/**
	 * Method to run batch operations.
	 *
	 * @param   object  $model  The model.
	 *
	 * @return  boolean   True if successful, false otherwise and internal error is set.
	 *
	 * @since   2.5
	 */
	public function batch($model = null)
	{
		$this->checkToken();

		// Set the model
		/** @var ContactModelContact $model */
		$model = $this->getModel('Linguise', '', array());

		// Preset the redirect
		$this->setRedirect(JRoute::_('index.php?option=com_linguise', false));

		return parent::batch($model);
	}
}
