<?php
/**
 * Linguise
 *
 * We developed this code with our hearts and passion.
 * We hope you found it useful, easy to understand and to customize.
 * Otherwise, please feel free to contact us at contact@linguise.com
 *
 * @package   Linguise
 * @copyright Copyright (C) 2021 Linguise (http://www.linguise.com). All rights reserved.
 * @license   GNU General Public License version 2 or later; http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') || die;

jimport('joomla.form.formfield');
JFormHelper::loadFieldClass('list');

/**
 * Form Field class for the Joomla Framework.
 */
class JFormFieldLanguages extends JFormFieldList
{
    /**
     * Type
     *
     * @var string
     */
    protected $type = 'Languages';


    /**
     * Method to get a list of tags
     *
     * @return array  The field option objects.
     */
    protected function getOptions()
    {

        $languages_content = file_get_contents(dirname(__FILE__) . '/../assets/languages.json');
        $languages_names = json_decode($languages_content);

        $options = [];
        foreach ($languages_names as $language_code => $language) {
            $options[$language_code] = $language->name;
        }

        return $options;
    }
}
