<?php
/**
 * @package Jollyany Addons SP Page Builder
 * @author TemPlaza https://templaza.com
 * @copyright Copyright (c) 2021 TemPlaza
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
// No direct access.
defined( '_JEXEC' ) or die( 'restricted aceess' );

class SppagebuilderAddonUiAccordion extends SppagebuilderAddons {

	public function render() {
		$settings = $this->addon->settings;

		$title_addon              = ( isset( $settings->title_addon ) && $settings->title_addon ) ? $settings->title_addon : '';
		$title_style              = ( isset( $settings->title_heading_style ) && $settings->title_heading_style ) ? ' uk-' . $settings->title_heading_style : '';
		$title_style             .= ( isset( $settings->title_heading_color ) && $settings->title_heading_color ) ? ' uk-' . $settings->title_heading_color : '';
		$title_style             .= ( isset( $settings->title_heading_margin ) && $settings->title_heading_margin ) ? ' ' . $settings->title_heading_margin : '';
		$title_heading_decoration = ( isset( $settings->title_heading_decoration ) && $settings->title_heading_decoration ) ? ' ' . $settings->title_heading_decoration : '';
		$title_heading_selector   = ( isset( $settings->title_heading_selector ) && $settings->title_heading_selector ) ? $settings->title_heading_selector : 'h3';

		$max_width_cfg              = ( isset( $settings->addon_max_width ) && $settings->addon_max_width ) ? ' uk-width-' . $settings->addon_max_width : '';
		$addon_max_width_breakpoint = ( $max_width_cfg ) ? ( ( isset( $settings->addon_max_width_breakpoint ) && $settings->addon_max_width_breakpoint ) ? '@' . $settings->addon_max_width_breakpoint : '' ) : '';

		$block_align            = ( isset( $settings->block_align ) && $settings->block_align ) ? $settings->block_align : '';
		$block_align_breakpoint = ( isset( $settings->block_align_breakpoint ) && $settings->block_align_breakpoint ) ? '@' . $settings->block_align_breakpoint : '';
		$block_align_fallback   = ( isset( $settings->block_align_fallback ) && $settings->block_align_fallback ) ? $settings->block_align_fallback : '';

		// Block Alignment CLS.
		$block_cls[] = '';

		if ( empty( $block_align ) ) {
			if ( ! empty( $block_align_breakpoint ) && ! empty( $block_align_fallback ) ) {
				$block_cls[] = ' uk-margin-auto-right' . $block_align_breakpoint;
				$block_cls[] = 'uk-margin-remove-left' . $block_align_breakpoint . ( $block_align_fallback == 'center' ? ' uk-margin-auto' : ' uk-margin-auto-left' );
			}
		}

		if ( $block_align == 'center' ) {
			$block_cls[] = ' uk-margin-auto' . $block_align_breakpoint;
			if ( ! empty( $block_align_breakpoint ) && ! empty( $block_align_fallback ) ) {
				$block_cls[] = 'uk-margin-auto' . ( $block_align_fallback == 'right' ? '-left' : '' );
			}
		}

		if ( $block_align == 'right' ) {
			$block_cls[] = ' uk-margin-auto-left' . $block_align_breakpoint;
			if ( ! empty( $block_align_breakpoint ) && ! empty( $block_align_fallback ) ) {
				$block_cls[] = $block_align_fallback == 'center' ? 'uk-margin-remove-right' . $block_align_breakpoint . ' uk-margin-auto' : 'uk-margin-auto-left';
			}
		}

		$block_cls = implode( ' ', array_filter( $block_cls ) );

		$max_width_cfg .= $addon_max_width_breakpoint . ( $max_width_cfg ? $block_cls : '' );

		$general      = '';
		$addon_margin = ( isset( $settings->addon_margin ) && $settings->addon_margin ) ? $settings->addon_margin : '';
		$general     .= ( $addon_margin ) ? ' uk-margin' . ( ( $addon_margin == 'default' ) ? '' : '-' . $addon_margin ) : '';

		$multiple     = ( isset( $settings->multiple ) && $settings->multiple ) ? 1 : 0;
		$multiple_cls = ( $multiple ) ? ' multiple: true' : '';
		$closed       = ( isset( $settings->closed ) && $settings->closed ) ? 1 : 0;
		$closed_cls   = ( $closed ) ? 'collapsible: true;' : 'collapsible: false;';
		$general     .= ( isset( $settings->visibility ) && $settings->visibility ) ? ' ' . $settings->visibility : '';
		$general     .= ( isset( $settings->class ) && $settings->class ) ? ' ' . $settings->class : '';

		$card      = ( isset( $settings->accordion_style ) && $settings->accordion_style ) ? ' uk-card-' . $settings->accordion_style : '';
		$card_size = ( isset( $settings->card_size ) && $settings->card_size ) ? ' ' . $settings->card_size : '';

		$positions = ( isset( $settings->positions ) && $settings->positions ) ? $settings->positions : '';

		$grid_cls    = ( isset( $settings->grid_width ) && $settings->grid_width ) ? ' uk-width-' . $settings->grid_width : '';
		$grid_cls_bp = ( isset( $settings->grid_breakpoint ) && $settings->grid_breakpoint ) ? '@' . $settings->grid_breakpoint : '';

		$vertical_alignment = ( isset( $settings->vertical_alignment ) && $settings->vertical_alignment ) ? 1 : 0;

		$image_grid_column_gap = ( isset( $settings->image_grid_column_gap ) && $settings->image_grid_column_gap ) ? $settings->image_grid_column_gap : '';
		$image_grid_row_gap    = ( isset( $settings->image_grid_row_gap ) && $settings->image_grid_row_gap ) ? $settings->image_grid_row_gap : '';

		$image_grid_cr_gap = '';
		if ( $image_grid_column_gap == $image_grid_row_gap ) {
			$image_grid_cr_gap .= ( ! empty( $image_grid_column_gap ) && ! empty( $image_grid_row_gap ) ) ? ' uk-grid-' . $image_grid_column_gap : '';
		} else {
			$image_grid_cr_gap .= ! empty( $image_grid_column_gap ) ? ' uk-grid-column-' . $image_grid_column_gap : '';
			$image_grid_cr_gap .= ! empty( $image_grid_row_gap ) ? ' uk-grid-row-' . $image_grid_row_gap : '';
		}

		$image_grid_cr_gap .= ( $vertical_alignment ) ? ' uk-flex-middle' : '';

		$img_class = ( $positions == 'right' ) ? ' uk-flex-last' . $grid_cls_bp . '' : '';

		$text_alignment          = ( isset( $settings->alignment ) && $settings->alignment ) ? ' ' . $settings->alignment : '';
		$text_breakpoint         = ( $text_alignment ) ? ( ( isset( $settings->text_breakpoint ) && $settings->text_breakpoint ) ? '@' . $settings->text_breakpoint : '' ) : '';
		$text_alignment_fallback = ( $text_alignment && $text_breakpoint ) ? ( ( isset( $settings->text_alignment_fallback ) && $settings->text_alignment_fallback ) ? ' uk-text-' . $settings->text_alignment_fallback : '' ) : '';

		$general .= $text_alignment . $text_breakpoint . $text_alignment_fallback;
		$general .= $max_width_cfg;

		// Parallax Animation.
		$horizontal_start = ( isset( $settings->horizontal_start ) && $settings->horizontal_start ) ? $settings->horizontal_start : '0';
		$horizontal_end   = ( isset( $settings->horizontal_end ) && $settings->horizontal_end ) ? $settings->horizontal_end : '0';
		$horizontal       = ( ! empty( $horizontal_start ) || ! empty( $horizontal_end ) ) ? 'x: ' . $horizontal_start . ',' . $horizontal_end . ';' : '';

		$vertical_start = ( isset( $settings->vertical_start ) && $settings->vertical_start ) ? $settings->vertical_start : '0';
		$vertical_end   = ( isset( $settings->vertical_end ) && $settings->vertical_end ) ? $settings->vertical_end : '0';
		$vertical       = ( ! empty( $vertical_start ) || ! empty( $vertical_end ) ) ? 'y: ' . $vertical_start . ',' . $vertical_end . ';' : '';

		$scale_start = ( isset( $settings->scale_start ) && $settings->scale_start ) ? ( (int) $settings->scale_start / 100 ) : 1;
		$scale_end   = ( isset( $settings->scale_end ) && $settings->scale_end ) ? ( (int) $settings->scale_end / 100 ) : 1;
		$scale       = ( ! empty( $scale_start ) || ! empty( $scale_end ) ) ? 'scale: ' . $scale_start . ',' . $scale_end . ';' : '';

		$rotate_start = ( isset( $settings->rotate_start ) && $settings->rotate_start ) ? $settings->rotate_start : '0';
		$rotate_end   = ( isset( $settings->rotate_end ) && $settings->rotate_end ) ? $settings->rotate_end : '0';
		$rotate       = ( ! empty( $rotate_start ) || ! empty( $rotate_end ) ) ? 'rotate: ' . $rotate_start . ',' . $rotate_end . ';' : '';

		$opacity_start = ( isset( $settings->opacity_start ) && $settings->opacity_start ) ? ( (int) $settings->opacity_start / 100 ) : 1;
		$opacity_end   = ( isset( $settings->opacity_end ) && $settings->opacity_end ) ? ( (int) $settings->opacity_end / 100 ) : 1;
		$opacity       = ( ! empty( $opacity_start ) || ! empty( $opacity_end ) ) ? 'opacity: ' . $opacity_start . ',' . $opacity_end . ';' : '';

		$easing     = ( isset( $settings->easing ) && $settings->easing ) ? ( (int) $settings->easing / 100 ) : '';
		$easing_cls = ( ! empty( $easing ) ) ? 'easing:' . $easing . ';' : '';

		$breakpoint     = ( isset( $settings->breakpoint ) && $settings->breakpoint ) ? $settings->breakpoint : '';
		$breakpoint_cls = ( ! empty( $breakpoint ) ) ? 'media: @' . $breakpoint . ';' : '';

		$viewport     = ( isset( $settings->viewport ) && $settings->viewport ) ? ( (int) $settings->viewport / 100 ) : '';
		$viewport_cls = ( ! empty( $viewport ) ) ? 'viewport:' . $viewport . ';' : '';

		$parallax_target = ( isset( $settings->parallax_target ) && $settings->parallax_target ) ? $settings->parallax_target : false;
		$target_cls      = ( $parallax_target ) ? ' target: !.sppb-section;' : '';

		// Default Animation.

		$animation        = ( isset( $settings->animation ) && $settings->animation ) ? $settings->animation : '';
		$animation_repeat = ( $animation ) ? ( ( isset( $settings->animation_repeat ) && $settings->animation_repeat ) ? ' repeat: true;' : '' ) : '';

		$parallax_zindex = ( isset( $settings->parallax_zindex ) && $settings->parallax_zindex ) ? $settings->parallax_zindex : false;
		$zindex_cls      = ( $parallax_zindex && $animation == 'parallax' ) ? ' uk-position-z-index uk-position-relative' : '';

		$delay_element_animations = ( isset( $settings->delay_element_animations ) && $settings->delay_element_animations ) ? $settings->delay_element_animations : '';
		$scrollspy_cls            = ( $delay_element_animations ) ? ' uk-scrollspy-class' : '';
		$scrollspy_target         = ( $delay_element_animations ) ? 'target: [uk-scrollspy-class]; ' : '';
		$animation_delay          = ( $delay_element_animations ) ? ' delay: 200;' : '';

		if ( $animation == 'parallax' ) {
			$animation = ' uk-parallax="' . $horizontal . $vertical . $scale . $rotate . $opacity . $easing_cls . $viewport_cls . $breakpoint_cls . $target_cls . '"';
		} elseif ( ! empty( $animation ) ) {
			$animation = ' uk-scrollspy="' . $scrollspy_target . 'cls: uk-animation-' . $animation . ';' . $animation_repeat . $animation_delay . '"';
		}

		$heading_style  = ( isset( $settings->title_color ) && $settings->title_color ) ? ' uk-text-' . $settings->title_color : '';
		$heading_style .= ( isset( $settings->title_text_transform ) && $settings->title_text_transform ) ? ' uk-text-' . $settings->title_text_transform : '';

		$content_style             = ( isset( $settings->content_style ) && $settings->content_style ) ? ' uk-' . $settings->content_style : '';
		$content_dropcap           = ( isset( $settings->content_dropcap ) && $settings->content_dropcap ) ? 1 : 0;
		$content_style            .= ( $content_dropcap ) ? ' uk-dropcap' : '';
		$content_style            .= ( isset( $settings->content_text_transform ) && $settings->content_text_transform ) ? ' uk-text-' . $settings->content_text_transform : '';
		$content_column            = ( isset( $settings->content_column ) && $settings->content_column ) ? ' uk-column-' . $settings->content_column : '';
		$content_column_breakpoint = ( $content_column ) ? ( ( isset( $settings->content_column_breakpoint ) && $settings->content_column_breakpoint ) ? '@' . $settings->content_column_breakpoint : '' ) : '';
		$content_column_divider    = ( $content_column ) ? ( ( isset( $settings->content_column_divider ) && $settings->content_column_divider ) ? ' uk-column-divider' : false ) : '';

		$content_style .= $content_column . $content_column_breakpoint . $content_column_divider;
		$content_style .= ( isset( $settings->content_margin_top ) && $settings->content_margin_top ) ? ' uk-margin-' . $settings->content_margin_top . '-top' : ' uk-margin-top';

		$attribs     = ( isset( $settings->target ) && $settings->target ) ? ' target="' . $settings->target . '"' : '';
		$btn_styles  = ( isset( $settings->button_style ) && $settings->button_style ) ? $settings->button_style : '';
		$button_size = ( isset( $settings->button_size ) && $settings->button_size ) ? ' ' . $settings->button_size : '';

		$button_style_cls = '';
		if ( empty( $btn_styles ) ) {
			$button_style_cls .= 'uk-button uk-button-default' . $button_size;
		} elseif ( $btn_styles == 'link' || $btn_styles == 'link-muted' || $btn_styles == 'link-text' ) {
			$button_style_cls .= 'uk-' . $btn_styles;
		} else {
			$button_style_cls .= 'uk-button uk-button-' . $btn_styles . $button_size;
		}

		$btn_margin_top   = ( isset( $settings->button_margin_top ) && $settings->button_margin_top ) ? 'uk-margin-' . $settings->button_margin_top . '-top' : 'uk-margin-top';
		$all_button_title = ( isset( $settings->all_button_title ) && $settings->all_button_title ) ? $settings->all_button_title : 'Learn more';

		$image_styles     = ( isset( $settings->image_border ) && $settings->image_border ) ? ' uk-border-' . $settings->image_border : '';
		$image_margin_top = ( isset( $settings->image_margin_top ) && $settings->image_margin_top ) ? ' uk-margin-' . $settings->image_margin_top . '-top' : ' uk-margin-top';

		$z_index_cls = ( ! empty( $parallax_bg_overlay_color ) ) ? ' uk-position-relative' : '';
		$output      = '';

		$output .= '<div class="ui-accordion' . $zindex_cls . $general . '">';
		if ( $title_addon ) {
			$output .= '<' . $title_heading_selector . ' class="tz-title' . $title_style . $title_heading_decoration . '">';

			$output .= ( $title_heading_decoration == ' uk-heading-line' ) ? '<span>' : '';

			$output .= nl2br( $title_addon );

			$output .= ( $title_heading_decoration == ' uk-heading-line' ) ? '</span>' : '';

			$output .= '</' . $title_heading_selector . '>';
		}

		$output .= '<div uk-accordion="' . $closed_cls . $multiple_cls . '" ' . $animation . '>';

		if ( isset( $settings->ui_accordion_item ) && count( (array) $settings->ui_accordion_item ) ) {
			foreach ( $settings->ui_accordion_item as $key => $item ) {
				$title     = ( isset( $item->title ) && $item->title ) ? $item->title : '';
				$content   = ( isset( $item->content ) && $item->content ) ? $item->content : '';
				$image     = ( isset( $item->image ) && $item->image ) ? $item->image : '';
				$image_src = isset( $image->src ) ? $image->src : $image;
				if ( strpos( $image_src, 'http://' ) !== false || strpos( $image_src, 'https://' ) !== false ) {
					$image_src = $image_src;
				} elseif ( $image_src ) {
					$image_src = JURI::base( true ) . '/' . $image_src;
				}
				$alt_text       = ( isset( $item->alt_text ) && $item->alt_text ) ? $item->alt_text : '';
				$title_alt_text = ( isset( $item->title ) && $item->title ) ? $item->title : '';
				$alt_text_init  = ( empty( $alt_text ) ) ? 'alt="' . str_replace( '"', '', $title_alt_text ) . '"' : 'alt="' . str_replace( '"', '', $alt_text ) . '"';

				$title_link        = ( isset( $item->link ) && $item->link ) ? $item->link : '';
				$check_target      = ( isset( $settings->target ) && $settings->target ) ? $settings->target : '';
				$render_linkscroll = ( empty( $check_target ) && strpos( $title_link, '#' ) === 0 ) ? ' uk-scroll' : '';

				$button_title = ( isset( $item->button_title ) && $item->button_title ) ? $item->button_title : '';
				if ( empty( $button_title ) ) {
					$button_title .= $all_button_title;
				}
				if ( ! empty( $card ) ) {
					$output .= '<div class="tz-item uk-card uk-card-body' . $card . $card_size . '"' . $scrollspy_cls . '>';
					$output .= '<a class="tz-title uk-accordion-title' . $heading_style . '" href="#">';
				} else {
					$output .= '<div class="uk-panel"' . $scrollspy_cls . '>';
					$output .= '<a class="tz-title uk-accordion-title' . $heading_style . '" href="#">';
				}

				$output .= $title;
				$output .= '</a>';

				$output .= '<div class="uk-accordion-content uk-margin-remove-first-child">';

				if ( ( $positions == 'left' || $positions == 'right' ) && $image_src ) {

					$output .= '<div class="uk-child-width-expand' . $image_grid_cr_gap . '" uk-grid>';

					$output .= '<div class="' . $grid_cls . $grid_cls_bp . $img_class . '">';

					$output .= '<img class="tz-image' . $image_styles . '" src="' . $image_src . '" ' . $alt_text_init . '>';

					$output .= '</div>';

					$output .= '<div>';

				}

				if ( $positions == 'top' && $image_src ) {
					$output .= '<img class="tz-image' . $image_styles . '" src="' . $image_src . '" ' . $alt_text_init . '>';
				}

				if ( $content ) {
					$output .= '<div class="ui-content uk-panel' . $content_style . '">';
					$output .= $content;
					$output .= '</div>';
				}

					$output .= ( $title_link ) ? '<div class="' . $btn_margin_top . '"><a class="' . $button_style_cls . '" href="' . $title_link . '"' . $attribs . $render_linkscroll . '>' . $button_title . '</a></div>' : '';

				if ( $positions == 'bottom' && $image_src ) {
					$output .= '<img class="tz-image' . $image_styles . $image_margin_top . '" src="' . $image_src . '" ' . $alt_text_init . '>';
				}

				if ( ( $positions == 'left' || $positions == 'right' ) && $image_src ) {
					$output .= '</div>';
					$output .= '</div>';
				}
				$output .= '</div>'; // end acc content div

				$output .= '</div>';
			}
		}

		$output .= '</div>';

		$output .= '</div>';

		return $output;
	}

	public function css() {
		$settings           = $this->addon->settings;
		$addon_id           = '#sppb-addon-' . $this->addon->id;
		$icon_align     	= ( isset( $settings->icon_align ) && $settings->icon_align ) ? 1 : 0;
		$styles             = ( isset( $settings->accordion_style ) && $settings->accordion_style ) ? $settings->accordion_style : '';
		$title_color        = ( isset( $settings->title_color ) && $settings->title_color ) ? $settings->title_color : '';
		$custom_title_color = ( isset( $settings->custom_title_color ) && $settings->custom_title_color ) ? 'color: ' . $settings->custom_title_color . ';' : '';
		$content_color      = ( isset( $settings->content_color ) && $settings->content_color ) ? 'color: ' . $settings->content_color . ';' : '';
		$link_button_style  = ( isset( $settings->button_style ) && $settings->button_style ) ? $settings->button_style : '';
		$button_background  = ( isset( $settings->button_background ) && $settings->button_background ) ? 'background-color: ' . $settings->button_background . ';' : '';
		$button_color       = ( isset( $settings->button_color ) && $settings->button_color ) ? 'color: ' . $settings->button_color . ';' : '';

		$button_background_hover = ( isset( $settings->button_background_hover ) && $settings->button_background_hover ) ? 'background-color: ' . $settings->button_background_hover . ';' : '';
		$button_hover_color      = ( isset( $settings->button_hover_color ) && $settings->button_hover_color ) ? 'color: ' . $settings->button_hover_color . ';' : '';

		$css = '';

		if ( empty( $title_color ) && $custom_title_color ) {
			$css .= $addon_id . ' .tz-title {' . $custom_title_color . '}';
		}

		if ($icon_align) {
			$css .= $addon_id . ' .uk-accordion-title::before { margin-right: 8px; margin-left: -8px; float: left; }';
		}
		if ( $content_color ) {
			$css .= $addon_id . ' .ui-content {' . $content_color . '}';
		}

		if ( $link_button_style == 'custom' ) {
			if ( $button_background || $button_color ) {
				$css .= $addon_id . ' .uk-button-custom {' . $button_background . $button_color . '}';
			}
			if ( $button_background_hover || $button_hover_color ) {
				$css .= $addon_id . ' .uk-button-custom:hover, ' . $addon_id . ' .uk-button-custom:focus, ' . $addon_id . ' .uk-button-custom:active {' . $button_background_hover . $button_hover_color . '}';
			}
		}

		if ( !empty( $styles ) ) {
            $css .= $addon_id . ' .ui-accordion .uk-card-small .uk-card-body, .ui-accordion .uk-card-small.uk-card-body {';
            $css .= 'padding: 12px 20px;';
            $css .= '}';
		}
		return $css;
	}
}
