<?php

/**
 * Linguise
 *
 * We developed this code with our hearts and passion.
 * We hope you found it useful, easy to understand and to customize.
 * Otherwise, please feel free to contact us at contact@joomunited.com *
 *
 * @package   Linguise
 * @copyright Copyright (C) 2013 JoomUnited (http://www.joomunited.com). All rights reserved.
 * @copyright Copyright (C) 2013 Damien Barrère (http://www.crac-design.com). All rights reserved.
 * @license   GNU General Public License version 2 or later; http://www.gnu.org/licenses/gpl-2.0.html
 * */
// no direct access
defined('_JEXEC') || die;
// phpcs:disable Squiz.Classes.ValidClassName.NotCamelCaps -- Default joomla core class name rule
/**
 * Class Com_LinguiseInstallerScript
 */
class Com_LinguiseInstallerScript
{
    /**
     * Com_LinguiseInstallerScript constructor.
     */
    public function __construct()
    {
        $this->oldRelease = $this->getVersion('com_linguise');
    }


    /**
     * Method to install the component
     *
     * @return void
     */
    public static function install()
    {
        $dbo = JFactory::getDbo();
        $query = "CREATE TABLE IF NOT EXISTS `#__linguise` (
  `id` int NOT NULL AUTO_INCREMENT,
  `option_key` text,
  `option_value` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;";
        $dbo->setQuery($query);
        $dbo->execute();
    }

    /**
     * Method to run after an install/update/uninstall method
     *
     * @param string $type   Type
     * @param object $parent Parent
     *
     * @return boolean
     */
    public function postflight($type, $parent)
    {
        if ($type === 'install') {
            if (!$this->oldRelease || $this->oldRelease === null) {
                JLoader::register('LinguiseHelper', JPATH_ADMINISTRATOR . '/components/com_linguise/helpers/linguise.php');
                $plugin_options = LinguiseHelper::getLinguisePluginOptions();
                $plugin_options_array = json_decode($plugin_options['params'], true);
                $options = LinguiseHelper::getLinguiseModuleOptions();
                $options_array = json_decode($options['params'], true);
                if (!empty($plugin_options_array['linguise_field_token'])) {
                    $options_array['linguise_field_token'] = $plugin_options_array['linguise_field_token'];
                }
                LinguiseHelper::updateLinguiseOptions($options_array);
            }
        }
        return true;
    }


    /**
     * Method to get the version of a component
     *
     * @param string $option Option
     *
     * @return null
     */
    private function getVersion($option)
    {
        $manifest = self::getManifest($option);
        if (!$manifest) {
            return null;
        }
        if (property_exists($manifest, 'version')) {
            return $manifest->version;
        }
        return null;
    }


    /**
     * Method to get an object containing the manifest values
     *
     * @param string $option Option
     *
     * @return boolean|mixed
     */
    private function getManifest($option)
    {
        $dbo = JFactory::getDbo();
        $query = 'SELECT extension_id FROM #__extensions WHERE element= ';
        $query .= $dbo->quote($option) . ' AND type = "component"';
        if (!$dbo->setQuery($query)) {
            return false;
        }
        if (!$dbo->execute()) {
            return false;
        }
        $component = $dbo->loadResult();
        if (!$component) {
            return false;
        }
        $table = JTable::getInstance('extension');
        // Load the previous Data
        if (!$table->load($component, false)) {
            return false;
        }
        return json_decode($table->manifest_cache);
    }
}
