<?php
defined('_JEXEC') or die;
$options = LinguiseHelper::getOptions(true);
$language_name_display = isset($options['language_name_display']) ? $options['language_name_display'] : 'en';
// Get from module parameters the enable languages
$languages_enabled_param = isset($options['languages_enabled']) ? $options['languages_enabled'] : array();
// Generate language list with default language as first item
if ($language_name_display === 'en') {
    $language_list = array($options['language_default'] => $languages_names[$options['language_default']]['name']);
} else {
    $language_list = array($options['language_default'] => $languages_names[$options['language_default']]['original_name']);
}

foreach ($languages_enabled_param as $language) {
    if ($language === $options['language_default']) {
        continue;
    }

    if (!isset($languages_names[$language])) {
        continue;
    }

    if ($language_name_display === 'en') {
        $language_list[$language] = $languages_names[$language]['name'];
    } else {
        $language_list[$language] = $languages_names[$language]['original_name'];
    }
}

$config = array_merge(array(
    'all_languages' => $languages_names,
    'languages' => $language_list,
), $options);
?>
<div class="content aside">
    <ul style="display: table-cell">
        <li class="linguise-settings-option full-width">
            <label class="linguise-setting-label label-bolder aside-label"
                   style="padding-left: 0"><?php echo JText::_('COM_LINGUISE_EDIT_TRANSLATIONS_LABEL') ?></label>
            <div class="items-blocks edit-translation-link">
                <ul>
                    <li><a href="https://www.linguise.com/documentation" target="_blank"
                           class="linguise-button aside-button waves-effect waves-light small-radius"><?php echo JText::_('COM_LINGUISE_DOCUMENT_LABEL') ?></a>
                    </li>
                    <li><a href="https://dashboard.linguise.com" target="_blank"
                           class="linguise-button aside-button waves-effect waves-light small-radius"><?php echo JText::_('COM_LINGUISE_DASHBOARD_LABEL') ?></a>
                    </li>
                </ul>
            </div>
        </li>
        <li class="linguise-settings-option full-width">
            <label class="linguise-setting-label label-bolder aside-label"
                   style="padding-left: 0"><?php echo JText::_('COM_LINGUISE_LANGUAGE_LIST_PREVIEW_LABEL') ?></label>
            <div class="items-blocks linguise_preview"
                 data-config="<?php echo htmlspecialchars(json_encode($config), ENT_QUOTES, 'UTF-8') ?>">

            </div>
        </li>
    </ul>
</div>