<?php
/**
 * Linguise
 *
 * We developed this code with our hearts and passion.
 * We hope you found it useful, easy to understand and to customize.
 * Otherwise, please feel free to contact us at contact@linguise.com *
 *
 * @package Linguise
 *
 * @copyright Copyright (C) 2021 Linguise (https://www.linguise.com). All rights reserved.
 *
 * @license GNU General Public License version 2 or later; http://www.gnu.org/licenses/gpl-2.0.html
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

class pkg_linguiseInstallerScript
{
    protected $installed_version = null;

    public function __construct()
    {
        $this->installed_version = $this->getVersion('com_linguise');
    }

    /**
     * This method is called after a component is installed.
     *
     * @param stdClass $parent - Parent object calling this method.
     *
     * @return void
     */
    public function install($parent)
    {
    }

    /**
     * method to run before an install/update/uninstall method
     *
     * @return void
     */
    public function preflight($type, $parent)
    {
    }

    function update($parent)
    {
    }

    /**
     * Method to run after an install/update/uninstall method
     *
     * @param $type
     * @param $parent
     *
     * @return void
     */
    function postflight($type, $parent)
    {
        if ($type === 'install') {
            // Enable Linguise system plugin
            $db = JFactory::getDbo();
            $db->setQuery('UPDATE #__extensions SET enabled=1 WHERE element ="linguise" AND type="plugin"');
            $db->execute();
        }
    }

    /**
     * Method to get the component version
     *
     * @param $option
     *
     * @return null
     */
    private function getVersion($option)
    {
        $manifest = self::getManifest($option);
        if (!$manifest) {
            return null;
        }
        if (property_exists($manifest, 'version')) {
            return $manifest->version;
        }
        return null;
    }

    /**
     * Method to get an object containing the manifest values
     *
     * @param $option
     *
     * @return object
     */
    private function getManifest($option)
    {
        $dbo = JFactory::getDbo();
        $query = 'SELECT extension_id FROM #__extensions WHERE element=' . $dbo->quote($option) . ' AND type="component"';
        if (!$dbo->setQuery($query)) {
            return false;
        }
        if (!$dbo->execute()) {
            return false;
        }
        $component = $dbo->loadResult();

        if (!$component) {
            return false;
        }
        $table = JTable::getInstance('extension');
        // Load the previous Data
        if (!$table->load($component, false)) {
            return false;
        }
        return json_decode($table->manifest_cache);
    }
}