<?php
/**
 * Linguise
 *
 * We developed this code with our hearts and passion.
 * We hope you found it useful, easy to understand and to customize.
 * Otherwise, please feel free to contact us at contact@linguise.com
 *
 * @package   Linguise
 * @copyright Copyright (C) 2021 Linguise (http://www.linguise.com). All rights reserved.
 * @license   GNU General Public License version 2 or later; http://www.gnu.org/licenses/gpl-2.0.html
 */

use Linguise\Script\Core\Configuration;
use Linguise\Script\Core\Database;
use Linguise\Script\Core\Processor;

define('LINGUISE_SCRIPT_TRANSLATION', true);
define('LINGUISE_SCRIPT_TRANSLATION_VERSION', 'joomla_plugin/1.3.4');

ini_set('display_errors', false);

require_once( __DIR__ . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php');

Configuration::getInstance()->load(__DIR__);

Configuration::getInstance()->set('cms', 'joomla');
Configuration::getInstance()->set('base_dir', realpath(__DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR  . '..' . DIRECTORY_SEPARATOR  . '..') . DIRECTORY_SEPARATOR);

$token = Database::getInstance()->retrieveJoomlaParam('linguise_field_token');
$cache_enabled = Database::getInstance()->retrieveJoomlaParam('cache_enabled');
$cache_max_size = Database::getInstance()->retrieveJoomlaParam('cache_max_size');

if (empty($cache_enabled)) {
    $cache_enabled = 0;
}

if (empty($cache_max_size)) {
    $cache_max_size = 0;
}

Configuration::getInstance()->set('token', $token);
Configuration::getInstance()->set('cache_enabled', $cache_enabled);
Configuration::getInstance()->set('cache_max_size', $cache_max_size);

$processor = new Processor();
if (isset($_GET['linguise_language']) && $_GET['linguise_language'] === 'zz-zz' &&  isset($_GET['linguise_action'])) {
    switch ($_GET['linguise_action']) {
        case 'clear-cache':
            $processor->clearCache();
            break;
        case 'update-certificates':
            $processor->updateCertificates();
            break;
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['linguise_language']) && $_GET['linguise_language'] === 'zz-zz') {
    $processor->editor();
} else {
    $processor->run();
}
