<?php

namespace Linguise\Script\Core;

defined('LINGUISE_SCRIPT_TRANSLATION') or die();

class Debug
{
    protected static $enabled = false;

    protected static $verbosity = 0;

    protected static $error_file;

    public static function enable($verbosity = 0)
    {
        self::$error_file = dirname(__FILE__) . '/../debug.php';

        if (!file_exists(self::$error_file)) {
            file_put_contents(self::$error_file, '<?php die(); ?>' . PHP_EOL);
        }

        self::$verbosity = (int)$verbosity;

        ini_set('error_log', self::$error_file);
        self::$enabled = true;
    }

    public static function disable()
    {
        self::$enabled = false;
    }

    public static function log($message, $verbosity = 0)
    {
        if (self::$enabled === false || $verbosity > self::$verbosity) {
            return;
        }

        if (!is_writable(self::$error_file)) {
            return;
        }

        error_log($message . PHP_EOL, 3, self::$error_file);
    }

    public static function timing($message, $start, $end = null, $verbosity = 0)
    {
        if (self::$enabled === false) {
            return;
        }

        if ($end === null) {
            $end = microtime(true);
        }

        $total = $end - $start;

        if ($total < 0.0001) {
            $total = number_format($total * 1000000, 3) . 'μs';
        } elseif ($total < 1) {
            $total = number_format($total * 1000, 3) . 'ms';
        } else {
            $total = number_format($total, 3) . 's';
        }

        $message = str_replace('%s', $total, $message);

        self::log($message, $verbosity);

    }
}